package ru.yandex.autotests.direct.web.data.firsthelp.recommendations;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 29.11.13
 */
public class AcceptRecommendedBannerParameters {

    private AcceptRecommendedBannersType acceptRecommendedBannersType;
    private Boolean stopOldBanners;
    private Boolean archiveOldBanners;

    public AcceptRecommendedBannerParameters(AcceptRecommendedBannersType acceptRecommendedBannersType,
                                             Boolean stopOldBanners, Boolean archiveOldBanners) {
        setAcceptRecommendedBannersType(acceptRecommendedBannersType);
        setStopOldBanners(stopOldBanners);
        setArchiveOldBanners(archiveOldBanners);
    }

    public AcceptRecommendedBannerParameters() {
        setAcceptRecommendedBannersType(AcceptRecommendedBannersType.ALL);
        setStopOldBanners(true);
        setArchiveOldBanners(false);
    }

    public void setAcceptRecommendedBannersType(AcceptRecommendedBannersType acceptRecommendedBannersType) {
        this.acceptRecommendedBannersType = acceptRecommendedBannersType;
    }

    public AcceptRecommendedBannersType getAcceptRecommendedBannersType() {
        return acceptRecommendedBannersType;
    }

    public void setStopOldBanners(Boolean stopOldBanners) {
        this.stopOldBanners = stopOldBanners;
    }

    public Boolean getStopOldBanners() {
        return stopOldBanners;
    }

    public void setArchiveOldBanners(Boolean archiveOldBanners) {
        this.archiveOldBanners = archiveOldBanners;
    }

    public Boolean getArchiveOldBanners() {
        return archiveOldBanners;
    }

    @Override
    public String toString() {
        String result = "";
        if (acceptRecommendedBannersType != null) {
            result = "Принять: " + acceptRecommendedBannersType.getName();
        }
        if (stopOldBanners != null) {
            result += " Остановить старые объявления : " + stopOldBanners;
        }
        if (archiveOldBanners != null) {
            result += " Архивировать: " + archiveOldBanners;
        }
        return result;
    }
}
