package ru.yandex.autotests.direct.web.data.groupenums;

import java.util.stream.Stream;

import com.google.gson.annotations.SerializedName;

/**
 * Created by ssdmitriev on 23.11.15.
 */
public enum FeedsFilterConditionsField {

    @SerializedName("id")
    ID("ID", "id"),
    @SerializedName("price")
    PRICE("price", "price"),
    @SerializedName("categoryId")
    CATEGORY_ID("category ID", "categoryId"),
    @SerializedName("url")
    URL("URL", "url"),
    @SerializedName("name")
    NAME("name", "name"),
    @SerializedName("model")
    MODEL("model", "model"),
    @SerializedName("vender")
    VENDOR("vendor", "vender");

    private String value;
    private String text;

    FeedsFilterConditionsField(String text, String value) {
        this.text = text;
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public String getText() {
        return text;
    }

    public static FeedsFilterConditionsField getEnumByValue(String value) {
        return Stream.of(values()).
                filter(t -> t.getValue().equals(value))
                .findFirst().orElse(null);
    }
}
