package ru.yandex.autotests.direct.web.data.groupenums;

import java.util.stream.Stream;

import com.google.gson.annotations.SerializedName;

/**
 * Created by ssdmitriev on 23.11.15.
 */
public enum IntervalConditions {
    @SerializedName("<")
    LESS("меньше", "<"),
    @SerializedName(">")
    MORE("больше", ">"),
    @SerializedName("==")
    EQUAL("равно", "=="),
    @SerializedName("<->")
    RANGE("диапазон", "<->"),
    @SerializedName("like")
    CONTAINS("содержит", "like"),
    @SerializedName("not like")
    NOT_CONTAINS("содержит", "not like");

    private String value;
    private String text;

    IntervalConditions(String text, String value) {
        this.text = text;
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public String getText() {
        return text;
    }

    public static IntervalConditions getEnumByValue(String value) {
        return Stream.of(values())
                .filter(t -> t.getValue().equals(value))
                .findFirst().orElse(null);
    }
}
