package ru.yandex.autotests.direct.web.data.groupenums;

import java.util.stream.Stream;

import com.google.gson.annotations.SerializedName;

/**
 * Created by ssdmitriev on 23.11.15.
 */
public enum SettingsModelEnum {
    @SerializedName("tree")
    FEED_TREE("Дерево фидов", "0"),
    @SerializedName("condition")
    CONDITIONS("Условия", "1");

    private String value;
    private String text;

    SettingsModelEnum(String text, String value) {
        this.text = text;
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public String getText() {
        return text;
    }

    public static SettingsModelEnum getEnumByValue(String value) {
        return Stream.of(values())
                .filter(t -> t.getValue().equals(value))
                .findFirst().orElse(null);
    }
}
