package ru.yandex.autotests.direct.web.data.groupenums;

import java.util.stream.Stream;

import com.google.gson.annotations.SerializedName;

/**
 * Created by ssdmitriev on 23.11.15.
 */
public enum TargetAudienceEnum {
    @SerializedName("product_page_visit")
    MY_SITE("Просматривали товар на моем сайте", "product_page_visit"),
    @SerializedName("same_products")
    SAME_PRODUCTS("Интересовались похожими товарами", "same_products"),
    @SerializedName("new_auditory")
    NEW_AUDITORY("Интересовались похожими товарами в сети", "new_auditory");

    private String value;
    private String text;

    TargetAudienceEnum(String text, String value) {
        this.text = text;
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public String getText() {
        return text;
    }

    public static TargetAudienceEnum getEnumByValue(String value) {
        return Stream.of(values())
                .filter(t -> t.getValue().equals(value))
                .findFirst().orElse(null);
    }
}
