package ru.yandex.autotests.direct.web.data.groupenums;

import java.util.stream.Stream;

/**
 * Created by ssdmitriev on 23.11.15.
 */
public enum TargetConditionsEnum {
    ALL_PAGES("Все страницы сайта", "any"),
    GROUP_OF_PAGES("Группа страниц", "detailed");
    private String value;
    private String text;
    TargetConditionsEnum(String text, String value) {
        this.text = text;
        this.value = value;
    }
    public String getValue() {
        return value;
    }

    public String getText() {
        return text;
    }

    public static TargetConditionsEnum getEnumByValue(String value) {
        return Stream.of(values())
                .filter(t -> t.getValue().equals(value))
                .findFirst().orElse(null);
    }
}
