package ru.yandex.autotests.direct.web.data.priceconstructor;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum BannerPhrasePlatform implements ITextResource {
    SEARCH("search"),
    CONTEXT("context"),
    DEFAULT("default"),
    MEDIAPLAN("mediaplan");

    BannerPhrasePlatform(String value) {
        this.value = value;
    }

    private String value;

    public String getValue() {
        return value;
    }

    @Override
    public String getBundle() {
        return "web.campaigns.priceconstructor.ConstructorPlatform";
    }

    @Override
    public String toString() {
        return TextResources.getKey(this);
    }
}
