package ru.yandex.autotests.direct.web.data.priceconstructor;

import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.hasNotNullProperty;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class ConstructorParameters {
    private String name;
    private ContextConstructor contextConstructor = new ContextConstructor();
    private SearchConstructor searchConstructor = new SearchConstructor();

    public ContextConstructor getContextConstructor() {
        return contextConstructor;
    }

    public SearchConstructor getSearchConstructor() {
        return searchConstructor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContextConstructor(ContextConstructor contextConstructor) {
        this.contextConstructor = contextConstructor;
    }

    public void setSearchConstructor(SearchConstructor searchConstructor) {
        this.searchConstructor = searchConstructor;
    }

    @Override
    public String toString() {
        return name == null ? "Constructor parameters" : name;
    }

    public boolean hasContextConstructorParameters() {
        return hasNotNullProperty(contextConstructor);
    }

    public boolean hasSearchConstructorParameters() {
        return hasNotNullProperty(searchConstructor);
    }
}
