package ru.yandex.autotests.direct.web.data.priceconstructor;

import java.util.function.Predicate;
import java.util.stream.Stream;

import ru.yandex.autotests.direct.web.util.DirectWebError;

public enum MediaplanTrafficVolume {
    FIVE("23", 5L),
    HUNDRED("10", 100L);

    private String id;
    private Long valueInInterface;

    MediaplanTrafficVolume(String id, Long valueInInterface) {
        this.id = id;
        this.valueInInterface = valueInInterface;
    }

    public String getId() {
        return id;
    }

    public Long getInterfaceValue() {
        return valueInInterface;
    }

    @Override
    public String toString() {
        return name();
    }

    public static MediaplanTrafficVolume getPriceTypeByName(String priceTypeName) {
        return getPriceType(x -> x.name().equals(priceTypeName));
    }

    public static MediaplanTrafficVolume getPriceTypeById(int id) {
        return getPriceType(x -> x.getId().equals(String.valueOf(id)));
    }

    public static MediaplanTrafficVolume getPriceType(Predicate<? super MediaplanTrafficVolume> predicate) {
        return Stream.of(MediaplanTrafficVolume.values()).filter(predicate).findFirst()
                .orElseThrow(() -> new DirectWebError("Не найден объем траффика, соответствующий условию"));
    }
}
