package ru.yandex.autotests.direct.web.data.priceconstructor;

import ru.yandex.autotests.direct.web.util.DirectWebError;

public enum TrafficVolume {
    VOLUME_MAX("макс."),
    VOLUME_100("100"),
    VOLUME_95("95"),
    VOLUME_90("90"),
    VOLUME_85("85"),
    VOLUME_80("80"),
    VOLUME_75("75"),
    VOLUME_15("15"),
    VOLUME_5("5");

    private String volume;

    TrafficVolume(String volume) {
        this.volume = volume;
    }

    public String getVolume() {
        return volume;
    }

    public static TrafficVolume valueOfSelect(String valueOfSelectText) {
        for (TrafficVolume item : TrafficVolume.values()) {
            if (item.getVolume().equals(valueOfSelectText)) {
                return item;
            }
        }
        throw new DirectWebError("Не найдено значение для объема " + valueOfSelectText);
    }
}
