package ru.yandex.autotests.direct.web.data.representatives;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 09.10.13
 */
public enum AgencyRepresentativeRole implements ITextResource {

    //TODO need change text resource key
    WORK_WITH_CLIENTS("limited"),
    ADMINISTRATOR("main");

    private String value;

    AgencyRepresentativeRole(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static AgencyRepresentativeRole getByValue(String value) {
        for (AgencyRepresentativeRole type : values()) {
            if (type.getValue().equals(value)) {
                return type;
            }
        }
        return null;
    }

    public static AgencyRepresentativeRole getByLabel(String label) {
        for (AgencyRepresentativeRole type : values()) {
            if (type.toString().equals(label)) {
                return type;
            }
        }
        return null;
    }

    @Override
    public String getBundle() {
        return "web.clients.RepresentativeRoles";
    }

    @Override
    public String toString() {
        return TextResources.getKey(this);
    }
}
