package ru.yandex.autotests.direct.web.data.representatives;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 11.10.13
 */
public enum Language {
    ENGLISH("en"),
    RUSSIAN("ru"),
    UKRAINE("ua");

    private String label;

    Language(String label) {
        this.label = label;
    }

    public String getLabel() {
        return label;
    }

    @Override
    public String toString() {
        return getLabel();
    }

    public static Language getByValue(String value) {
        for (Language type : values()) {
            if (type.getLabel().equals(value)) {
                return type;
            }
        }
        return null;
    }
}
