package ru.yandex.autotests.direct.web.data.showcampaigns;

import java.util.Arrays;
import java.util.List;

/**
 * Enum линок с действиями
 *
 * @author Vitaliy_Dobriyan
 */
public enum ActionLinks {
    SHOW_CAMPAIGN("Новая кампания"),
    ARCHIVE("campArc"),
    UNARCHIVE("campUnarc"),
    DELETE("delCamp"),
    PARAMETERS("editCamp"),
    STOP("stopCamp"),
    RESUME("resumeCamp"),
    OFFER_TO_SERVICING("offerToServicing"),
    PAY("pay"),
    STATISTICS("showCampStat");

    private String cmd;

    ActionLinks(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public String toString() {
        return cmd;
    }

    // наборы линок для типов кампаний
    public static List<String> getArchivedCampActionLinksList() {
        return Arrays.asList(UNARCHIVE.cmd,
                PARAMETERS.cmd,
                DELETE.cmd);
    }

    public static List<String> getResumedCampActionLinksList() {
        return Arrays.asList(PARAMETERS.cmd,
                STOP.cmd);
    }

    public static List<String> getStoppedCampActionLinksList() {
        return Arrays.asList(ARCHIVE.cmd,
                PARAMETERS.cmd,
                RESUME.cmd,
                DELETE.cmd);
    }

}