package ru.yandex.autotests.direct.web.data.showcampaigns;


import java.util.List;

import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.web.data.textresources.ShowCampaignsResource;


/**
 * Enum столбцов таблицы кампаний
 *
 * @author Vitaliy_Dobriyan
 */
public enum ShowCampsColumns {

    NAME(ShowCampaignsResource.CAMPAIGN_NAME, "campaignName"),
    CAMP_ID(ShowCampaignsResource.CAMP_NUMBER, "campaignNumber"),
    PARAMETERS(ShowCampaignsResource.PARAMETERS_COLUMN, "parametersValue"),
    STATUS(ShowCampaignsResource.STATUS_COLUMN, "statusValue"),
    START_TIME(ShowCampaignsResource.START_COLUMN, "startValue"),
    CLICKS(ShowCampaignsResource.CLICKS_COLUMN, "clicksValue"),
    TOTAL(ShowCampaignsResource.TOTAL_COLUMN, "totalValue"),
    MONEY_SUM(ShowCampaignsResource.SUM_COLUMN, "moneySumValue");

    private ITextResource name;
    private String campRowFieldName;

    ShowCampsColumns(ITextResource name, String campRowFieldName) {
        this.name = name;
        this.campRowFieldName = campRowFieldName;
    }

    @Override
    public String toString() {
        return name.toString();
    }

    public ITextResource getColumnName() {
        return name;
    }

    /**
     * Получение линки сортировки для колонки, соответствующей элементу enum'а
     *
     * @param columnsList - Список колонок
     * @return - объект линки или null, если такой колонки нет
     */
    public WebElement getColumnLink(List<WebElement> columnsList) {
        for (WebElement columnLink : columnsList) {
            if (columnLink.getText().contains(name.toString())) {
                return columnLink;
            }
        }
        return null;
    }
}
