package ru.yandex.autotests.direct.web.data.showcampaigns;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.web.data.textresources.ShowCampaignsResource;

/**
 * Enum параметров сортировки
 *
 * @author Vitaliy_Dobriyan
 */
public enum SortParameters {

    //Parameters
    THEMATIC_AREAS("Тематические площадки",
            "dontShowYacontext",
            ShowCampaignsResource.THEMATIC_AREAS),
    DISABLED_IPS("Запрещённые IP",
            "disabledIps",
            ShowCampaignsResource.DISABLED_IPS),
    SITE_MONITORING("Мониторинг сайта",
            "statusMetricaControl",
            ShowCampaignsResource.SITE_MONITORING),
    DISABLED_DOMAINS("Запрещённые площадки",
            "DontShow",
            ShowCampaignsResource.DISABLED_DOMAINS),
    ADDITIONAL_PHRASES("Доп. фразы",
            "broad_match_flag",
            ShowCampaignsResource.ADDITIONAL_PHRASES),
    STRATEGY_INDEPENDENT_CONTROL("Стратегия: независимое управление",
            "sDifferentPlaces",
            ShowCampaignsResource.STRATEGY_INDEPENDENT_CONTROL),
    STRATEGY_DISPLAY_IN_BLOCK_AT_MINIMUM_PRICE("Стратегия: в блоке по мин. цене",
            "sMinprice",
            ShowCampaignsResource.STRATEGY_DISPLAY_IN_BLOCK_AT_MINIMUM_PRICE),
    STRATEGY_WEEKLY_CLICKS_PACKAGE("Стратегия: недельный пакет кликов",
            "sAutobudgetWeekBundle",
            ShowCampaignsResource.STRATEGY_WEEKLY_CLICKS_PACKAGE),
    STRATEGY_AVERAGE_CLICK_PRICE("Стратегия: средняя цена клика",
            "sAutobudgetAvgClick",
            ShowCampaignsResource.STRATEGY_AVERAGE_CLICK_PRICE),
    STRATEGY_WEEKLY_BUDGET("Стратегия: недельный бюджет",
            "sAutobudget",
            ShowCampaignsResource.STRATEGY_WEEKLY_BUDGET),
    STRATEGY_HIGHEST_AVAILABLE_POSITION("Стратегия: наивысшая позиция",
            "sDefault",
            ShowCampaignsResource.STRATEGY_HIGHEST_AVAILABLE_POSITION),
    STRATEGY_AVERAGE_CPA("Стратегия: Средняя цена конверсии",
            "sAutobudgetAvgCpa",
            ShowCampaignsResource.STRATEGY_AVERAGE_CPA),
    STRATEGY_ROI_OPTIMIZATION("Стратегия: Средняя рентабельность инвестиций",
            "sAutobudgetRoi",
            ShowCampaignsResource.STRATEGY_ROI_OPTIMIZATION);


    private String parameterName;
    private ITextResource parameterText;
    private String value;

    SortParameters(String parameterName, String value, ITextResource parameterText) {
        this.parameterName = parameterName;
        this.parameterText = parameterText;
        this.value = value;
    }


    @Override
    public String toString() {
        return parameterName;
    }

    public String getParameterRadioValue() {
        return value;
    }

    public ITextResource getSortParameterText() {
        return parameterText;
    }
}
