package ru.yandex.autotests.direct.web.data.statistic;

import java.util.stream.Stream;

import static java.util.stream.Collectors.joining;

public enum SearchQueriesSlices {
    SIM_DISTANCE("sim_distance"),
    SEARCH_QUERY("search_query"),
    CAMPAIGN_TYPE("campaign_type"),
    CAMPAIGN("campaign"),
    ADGROUP("adgroup"),
    BANNER("banner"),
    CONTEXTTYPE("contexttype"),
    CONTEXTCOND_EXT("contextcond_ext");

    private String value;

    SearchQueriesSlices(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    public static String allSlices() {
        return Stream.of(SearchQueriesSlices.values()).map(SearchQueriesSlices::toString).collect(joining(","));
    }
}
