package ru.yandex.autotests.direct.web.data.strategy.cpm;

import java.util.stream.Stream;

import ru.yandex.autotests.direct.web.util.DirectWebError;

public enum CpmManualShowModeEnum {
    STANDARD("default"),
    STRETCHED("stretched");

    private String value;

    CpmManualShowModeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static CpmManualShowModeEnum deserializeFromString(String value) {
        return Stream.of(CpmManualShowModeEnum.values()).filter(x -> x.getValue().equals(value))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Неизвестный тип распределения показов: " + value));
    }
}