package ru.yandex.autotests.direct.web.data.strategy.cpm;

import java.util.stream.Stream;

import ru.yandex.autotests.direct.web.util.DirectWebError;

public enum CpmStrategiesEnum {
    MANUAL("cpm_default"),
    MAX_REACH("autobudget_max_reach"),
    MAX_IMPRESSIONS("autobudget_max_impressions");

    private String value;

    CpmStrategiesEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static CpmStrategiesEnum deserializeFromString(String value) {
        return Stream.of(CpmStrategiesEnum.values()).filter(x -> x.getValue().equals(value))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Неизвестный тип стратегии: " + value));
    }
}