package ru.yandex.autotests.direct.web.data.strategy.cpm;

import java.util.stream.Stream;

import ru.yandex.autotests.direct.web.util.DirectWebError;

public enum CpmStrategySpendMode {
    BY_PERIOD("period"),
    BY_WEEK("week");

    private String value;

    CpmStrategySpendMode(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static CpmStrategySpendMode deserializeFromString(String value) {
        return Stream.of(CpmStrategySpendMode.values()).filter(x -> x.getValue().equals(value))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Неизвестный тип периода: " + value));
    }
}