package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * Author buhter
 * Date 10.06.14
 */
public enum CampaignsCopyResource implements ITextResource {

    EMPTY_FIELDS_ERROR,
    NO_BANNERS_ERROR,
    ARCHIVED_ERROR,
    NOT_A_NUMBER_ERROR,
    NOT_EXISTS_ERROR,
    MUST_ENTER_CID,
    CAMPAIGN_DOES_NOT_BELONG_ERROR,
    CLIENT_DOES_NOT_BELONG_ERROR,
    SUCCESSFULLY_COPIED_MESSAGE,
    SUCCESSFULLY_MULTIPLE_COPIED_MESSAGE,
    NO_CAMPAIGNS_FOR_COPY,
    CURRENCY_CONVERSION_WARNING;

    @Override
    public String getBundle() {
        return "web.campaigns.Copy";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
