package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 21.10.13
 */
public enum ClientAlertsResource implements ITextResource {

    CONFIRM_DELETION_ALERT_TEXT,
    CONFIRM_SAVE_ALERT_TEXT,
    CONFIRM_ARCHIVE_CLIENT_ALERT_TEXT,
    CONFIRM_UNARCHIVE_CLIENT_ALERT_TEXT,
    AGENCY_NOT_FOUND,
    CONFIRM_CREATE_NEW_AGENCY_ALERT_TEXT,
    CONFIRM_SAVE_CLIENT_LIST_CHANGES_TEXT,
    CONFIRM_AGENCY_REPRESENTATIVE_DELETION;

    @Override
    public String getBundle() {
        return "web.clients.Alerts";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
