package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum ContactInfoResource implements ITextResource {

    SERVER_VALIDATION_COUNTRY_NOT_INPUT,
    SERVER_VALIDATION_CITY_NOT_INPUT,
    SERVER_VALIDATION_COUNTRY_CODE_NOT_INPUT,
    SERVER_VALIDATION_CITY_CODE_NOT_INPUT,
    SERVER_VALIDATION_PHONE_NOT_INPUT,
    SERVER_VALIDATION_FIO_NOT_INPUT,
    SERVER_VALIDATION_INVALID_WORK_TIME_INTERVALS,
    JS_VALIDATION_REQUIRED_FIELDS_EMPTY,
    JS_VALIDATION_COUNTRY,
    JS_VALIDATION_CITY,
    JS_VALIDATION_COUNTRY_CODE,
    JS_VALIDATION_CITY_CODE,
    JS_VALIDATION_PHONE,
    JS_VALIDATION_FIO,
    CONTACT_INFO_CHANGE_ALERT_TEXT;


    //validation messages

    @Override
    public String getBundle() {
        return "web.ContactInfoTextData";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
