package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum EditCampaignResource implements ITextResource {

    SET_REGION_INFO_MESSAGE,
    SET_EXTERNAL_INTERNET_STAT_INFO_MESSAGE,
    OPENSTAT_METRIKA_LINKS_WILL_BE_TURNED_ON_MESSAGE,
    SET_MONITORING_INFO_MESSAGE,

    //validation messages
    CAMPAIGN_NAME_VALIDATION_MESSAGE,
    FIO_VALIDATION_MESSAGE,
    START_DATE_VALIDATION_MESSAGE,
    NOTIFICATION_MONEY_WARNING_VALUE_VALIDATION_MESSAGE,
    DISABLED_DOMAIN_VALIDATION_MESSAGE,
    MANY_METRIKA_COUNTERS_VALIDATION_MESSAGE,
    DISABLED_IP_VALIDATION_MESSAGE,
    CONTACT_INFO_CHANGE_ALERT_TEXT,
    EMPTY_REGIONS_SERVER_ALERT_TEXT,
    EMPTY_REGIONS_CLIENT_ALERT_TEXT,
    CLEAR_ALL_REGIONS_IN_GROUP_ALERT_TEXT,

    NEW_CAMP_PAGE_TITLE,
    TITLE_CAMPAIGN_PARAMETERS,
    SET_PRICE_FOR_CLICK,

    ADD_RELEVANT_PHRASES_MODE_OPT,
    ADD_RELEVANT_PHRASES_MODE_MIN,
    ADD_RELEVANT_PHRASES_MODE_MAX,

    PAUSE_CAMPAIGN_BUTTON_TEXT,
    RESUME_CAMPAIGN_BUTTON_TEXT;

    @Override
    public String getBundle() {
        return "web.campaigns.EditCampTextData";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
