package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * User: alexey-n
 * Date: 08.09.13
 * Time: 18:26
 */
public enum MediaplanCommonResource implements ITextResource {

    MEDIAPLAN_STATUS_AWAITING_APPROVAL,
    EDIT_MEDIAPLAN_WINDOW_TITLE,
    SEND_REQUEST_TYPE_MEDIA,
    SEND_REQUEST_TARGET,
    SEND_REQUEST_TARGET_CAMP,
    SEND_REQUEST_BUDGET,
    SEND_REQUEST_MAIL_TO,
    SEND_REQUEST_TITLE,
    CREATE_MEDIAPLAN,
    CHOOSE_PRICE;

    @Override
    public String getBundle() {
        return "web.mediaplans.MediaplanCommonTextData";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
