package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum PhrasesTextData implements ITextResource {

    ERROR_PRICE_MUST_BE_NOT_GREATER,
    ERROR_PRICE_MUST_BE_NOT_LESS,
    PHRASE_PRIORITY_LOW,
    PHRASE_PRIORITY_MEDIUM,
    PHRASE_PRIORITY_HIGH,
    ALERT_CANT_DELETE_LAST_PHRASE;

    @Override
    public String getBundle() {
        return "web.banners.PhrasesTextData";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
