package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.web.util.helpers.TextResourceHelper;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum PriceConstructorResource implements ITextResource {

    COMMON_PRICE_TAB,
    WIZARD_BIDS_TAB,
    ALERT_LESS_THAN_MIN_PRICE,
    ALERT_GREATER_THAN_MAX_PRICE,
    ALERT_WRONG_PRICE,
    ALERT_LESS_THAN_MIN_PERCENT,
    ALERT_GREATER_THAN_MAX_PERCENT,
    ALERT_WRONG_PERCENT,
    ALERT_SET_PRICE,
    CONSTRUCTOR_SWITCHER_SEARCH,
    CONSTRUCTOR_SWITCHER_CONTEXT;

    @Override
    public String getBundle() {
        return "web.campaigns.priceconstructor.PriceConstructor";
    }

    @Override
    public String toString() {
        return TextResourceHelper.resource(this).toString();
    }
}
