package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.web.util.helpers.TextResourceHelper;

/**
 * Created with IntelliJ IDEA.
 * User: alexey-n
 * Date: 10.11.13
 * Time: 21:17
 * To change this template use File | Settings | File Templates.
 */
public enum StrategiesResource implements ITextResource {

    HIGHEST_POSITION,
    WEEKLY_BUDGET,
    CPAOPTIMIZER,
    LOWEST_COST_PREMIUM,
    LOWEST_COST,
    RIGHTBLOCKHIGHEST,
    LOWESTCOSTGUARANTEE,
    AVERAGE_CLICK_PRICE,
    WEEKLY_PACKET_OF_CLICKS,
    INDEPENDENT_CONTROL,
    MAXIMUMCOVERAGE,
    SHOWSDISABLED,
    DEFAULT,
    AVERAGE_PRICE_PER_CLICK,
    MAX_PRICE_PER_CLICK,
    WEEKLY_BUDGET_MAX_CLICKS_MAX_PRICE_WEEKLY_SUM_INFO_TEXT,
    WEEKLY_BUDGET_MAX_CLICKS_WEEKLY_SUM_INFO_TEXT,
    WEEKLY_BUDGET_MAX_CONVERSION_MAX_PRICE_WEEKLY_SUM_INFO_TEXT,
    WEEKLY_BUDGET_MAX_CONVERSION_WEEKLY_SUM_INFO_TEXT,
    WEEKLY_PACKET_OF_CLICKS_CLICKS_PER_WEEK_INFO_TEXT,
    WEEKLY_PACKET_OF_CLICKS_MAX_PRICE_INFO_TEXT,
    WEEKLY_PACKET_OF_CLICKS_AVERAGE_PRICE_INFO_TEXT,
    AVERAGE_PRICE_WEEKLY_SUM_INFO_TEXT,
    AVERAGE_PRICE_AVERAGE_PRICE_INFO_TEXT,
    STRATEGY_INFO,
    CONTEXT_STRATEGY_INFO,
    CONTEXT_STRATEGY_LIMIT_INFO,
    CONTEXT_STRATEGY_MAX_PRICE_LIMIT_INFO,
    CONTEXT_STRATEGY_USER_REQUIREMENTS,
    CONTEXT_DEFAULT,
    CONTEXT_SHOWDISABLED,
    ALERT_OUT_OF_LOWER_BOUND_MAX_PRICE,
    ALERT_OUT_OF_UPPER_BOUND_MAX_PRICE,
    ALERT_OUT_OF_LOWER_BOUND_AVERAGE_PRICE,
    ALERT_OUT_OF_UPPER_BOUND_AVERAGE_PRICE,
    ALERT_OUT_OF_LOWER_BOUND_WEEKLY_SUM_LIMIT,
    ALERT_OUT_OF_UPPER_BOUND_WEEKLY_SUM_LIMIT,
    ALERT_OUT_OF_LOWER_BOUND_CLICKS_PER_WEEK,
    ALERT_OUT_OF_UPPER_BOUND_CLICKS_PER_WEEK,
    ALERT_AVERAGE_PRICE_UPPER_WEEKLY_SUM_LIMIT,
    ALERT_MAX_PRICE_UPPER_WEEKLY_SUM_LIMIT,
    ALERT_MAX_PRICE_UPPER_WEEKLY_SUM_LIMIT_ON_SERVER,
    ALERT_AVG_CPA_UPPER_WEEKLY_SUM_LIMIT,
    ALERT_AVG_CPI_UPPER_WEEKLY_SUM_LIMIT,
    ALERT_AVG_CPI_CANNOT_BE_ACTIVATE,
    ALERT_OUT_OF_LOWER_BOUND_AVG_CPA,
    ALERT_OUT_OF_LOWER_BOUND_AVG_CPI,
    ALERT_OUT_OF_UPPER_BOUND_MAX_PRICE_CPA,
    ALERT_OUT_OF_LOWER_BOUND_MAX_PRICE_CPA,
    ALERT_OUT_OF_LOWER_BOUND_ROI_COEF,
    ALERT_OUT_OF_BOUND_PROFITABILITY,
    ALERT_OUT_OF_UPPER_BOUND_MAX_PRICE_ROI,
    ALERT_OUT_OF_LOWER_BOUND_MAX_PRICE_ROI,
    ALERT_MAX_PRICE_UPPER_WEEKLY_SUM_LIMIT_WEB,
    ALERT_OUT_OF_LOWER_BOUND_MAX_PRICE_WEB,
    ALERT_OUT_OF_UPPER_BOUND_MAX_PRICE_WEB,
    ALERT_OUT_OF_UPPER_BOUND_AVERAGE_PRICE_WEB,
    ALERT_OUT_OF_UPPER_BOUND_WEEKLY_SUM_LIMIT_WEB,
    ALERT_DAY_BUDGET_IS_EMPTY,
    ALERT_BUDGET_SHOULD_NOT_BE_LESS_THAN,
    ALERT_WEEK_BUDGET_SHOULD_NOT_BE_LESS_THAN_300,
    ALERT_WEEK_BUDGET_SHOULD_NOT_BE_LESS_THAN_2100;

    @Override
    public String getBundle() {
        return "web.campaigns.strategy.StrategyType";
    }

    @Override
    public String toString() {
        return TextResourceHelper.resource(this).toString();
    }

    public static StrategiesResource getResourceByName(String resourceName) {
        for (StrategiesResource resource : StrategiesResource.values()) {
            if (resource.name().equals(resourceName)) {
                return resource;
            }
        }
        return null;
    }
}
