package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum TimeTargetTestStrings implements ITextResource {

    //window titles
    WINDOW_TITLE_MANAGEMENT_SHOWS_WORKING_HOLIDAYS,
    WINDOW_TITLE_MANAGEMENT_SHOWS_HOLIDAYS,
    HOURLY_CLICK_PRICE_ADJUSTMENT,

    //titles
    TITLE_ON_HOLIDAYS,
    TITLE_WORKING_HOLIDAYS,
    TITLE_SHOW,
    TITLE_TIME,
    TITLE_SHOW_ON_HOLIDAYS,// = TITLE_ON_HOLIDAYS + ": " + getString("TITLE_SHOW_ON_HOLIDAYS");
    TITLE_DONT_SHOW_ON_HOLIDAYS, //= TITLE_ON_HOLIDAYS + ": "
    //+ getString("TITLE_DONT_SHOW_ON_HOLIDAYS");
    TITLE_LIMITATION_OF_THE_PRICE_OF_CLICKS_AT_THE_LEVEL_OF,
    TITLE_SET_LIMIT_PRICE_OF_CLICKS,
    TITLE_ROUND_THE_CLOCK,

    //formats
    FORMAT_HOLIDAYS_SELECT_HOUR,
    FORMAT_HOLIDAYS_SUMMARY_HOUR,
    FORMAT_HOLIDAYS_SELECT_PERCENT,

    //errors
    ERROR_MINIMUM_SELECTED_WORKING_HOURS,
    ERROR_POPUP_MINIMUM_SELECTED_WORKING_HOURS;

    @Override
    public String getBundle() {
        return "web.campaigns.TimeTargetTextData";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
