package ru.yandex.autotests.direct.web.data.textresources;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * User: xy6er
 * Date: 28.08.13
 * Time: 20:44
 */

public enum WeekDays implements ITextResource {

    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY,
    SHORT_MONDAY,
    SHORT_TUESDAY,
    SHORT_WEDNESDAY,
    SHORT_THURSDAY,
    SHORT_FRIDAY,
    SHORT_SATURDAY,
    SHORT_SUNDAY;

    public static int getNumberOfDay(String nameOrShortName) {
        for (WeekDays weekDays : WeekDays.values()) {
            if (weekDays.toString().equalsIgnoreCase(nameOrShortName)) {
                return weekDays.ordinal() % 7;
            }
        }
        return -1;
    }

    @Override
    public String getBundle() {
        return "web.campaigns.WeekDays";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
