package ru.yandex.autotests.direct.web.data.timetarget;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum TimeZoneGroups implements ITextResource {
    RUSSIA,
    CIS,
    WORLD;

    @Override
    public String getBundle() {
        return "web.campaigns.timetarget.TimeZone";
    }

    public static TimeZoneGroups getByValue(String value) {
        for (TimeZoneGroups timeZoneGroups : TimeZoneGroups.values()) {
            if (timeZoneGroups.toString().equals(value)) {
                return timeZoneGroups;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
