package ru.yandex.autotests.direct.web.data.timetarget;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum TimeZones implements ITextResource {
    MOLDOVA("243"),
    AUSTRALIA("91"),
    VLADIVOSTOK("138");

    private String value;

    TimeZones(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String getBundle() {
        return "web.campaigns.timetarget.TimeZone";
    }

    public static TimeZones getByValue(String value) {
        for (TimeZones timeZones : TimeZones.values()) {
            if (timeZones.getValue().equals(value)) {
                return timeZones;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
