package ru.yandex.autotests.direct.web.helpers;

import java.net.URI;
import java.net.URISyntaxException;

import ru.yandex.autotests.direct.cmd.data.BasicDirectRequest;
import ru.yandex.autotests.direct.cmd.data.CMD;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.httpclientlite.context.ConnectionContext;
import ru.yandex.autotests.httpclientlite.context.ContextRequestExecutor;

import static org.hamcrest.Matchers.containsString;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class UrlBuilderHelper extends ContextRequestExecutor {
    public UrlBuilderHelper(String baseUrl) {
        super(null, new ConnectionContext()
                .scheme("https")
                .host(getDomainName(baseUrl))
                .path("/registered/main.pl"));
    }

    private static String getDomainName(String url) {
        assumeThat("url содержит схему", url, containsString("://"));
        URI uri = null;
        try {
            uri = new URI(url);
        } catch (URISyntaxException e) {
            throw new DirectWebError("Не удалось распарсить url", e);
        }
        String domain = uri.getHost();
        return domain.startsWith("www.") ? domain.substring(4) : domain;
    }

    public String getUrl(BasicDirectRequest request, CMD cmd) {
        return super.buildURI(request).toString() + "&cmd=" + cmd.getName();
    }

    public String getUrl(String params) {
        return super.buildURI().toString() + "?" + params;
    }
}
