package ru.yandex.autotests.direct.web.objects.autopayment;

import ru.yandex.autotests.direct.web.data.autopayment.AutoPaymentTypeEnum;

public class AutoPaymentWeb {

    private Boolean enabled;
    private String remainingSum;
    private String paymentSum;
    private AutoPaymentTypeEnum paymentType;
    private String paymentId;

    public Boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getRemainingSum() {
        return remainingSum;
    }

    public void setRemainingSum(String remainingSum) {
        this.remainingSum = remainingSum;
    }

    public String getPaymentSum() {
        return paymentSum;
    }

    public void setPaymentSum(String paymentSum) {
        this.paymentSum = paymentSum;
    }

    public AutoPaymentTypeEnum getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(AutoPaymentTypeEnum paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentId() {
        return paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public AutoPaymentWeb withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AutoPaymentWeb withRemainingSum(String remainingSum) {
        this.remainingSum = remainingSum;
        return this;
    }

    public AutoPaymentWeb withPaymentSum(String paymentSum) {
        this.paymentSum = paymentSum;
        return this;
    }

    public AutoPaymentWeb withPaymentType(AutoPaymentTypeEnum paymentType) {
        this.paymentType = paymentType;
        return this;
    }

    public AutoPaymentWeb withPaymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }
}
