package ru.yandex.autotests.direct.web.objects.banners;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.autotests.direct.web.data.banners.DirectBannerType;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.ContactInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.TurboLandingInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.VideoInfoWeb;

import ru.yandex.autotests.direct.web.objects.imagead.ImageAdWeb;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class BannerInfoWeb implements Serializable {
    private List<String> tags;

    private List<String> callouts;

    private Boolean isMobileBannerType;

    private String displayHref;

    private DirectBannerType bannerType;

    private ImageAdWeb imageAd;

    private VideoInfoWeb video;

    private Long bannerId;

    private Long campaignId;

    private String title;

    private String titleExtension;

    private String text;

    private String href;

    private String domain;

    private ContactInfoWeb contactInfo;

    private String geo;

    private BannerPhraseInfoWeb[] phrases;

    private String statusSitelinksModerate;

    private String[] minusKeywords;

    private String statusShow;

    private SiteLinkInfoWeb[] sitelinks;

    private Long adGroupID;

    private HierarchicalMultipliersWeb hierarchicalMultipliersWeb;

    private String adGroupName;

    private String isActive;

    private Double maxClickPrice;

    private Boolean isRelevanceMatchEnabled;

    private TurboLandingInfoWeb turboLanding;

    public String getStatusShow() {
        return statusShow;
    }

    public void setStatusShow(String statusShow) {
        this.statusShow = statusShow;
    }

    public String getAdGroupName() {
        return adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }


    public HierarchicalMultipliersWeb getHierarchicalMultipliersWeb() {
        return hierarchicalMultipliersWeb;
    }

    public void setHierarchicalMultipliersWeb(HierarchicalMultipliersWeb hierarchicalMultipliersWeb) {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
    }

    public List<String> getCallouts() {
        return callouts;
    }

    public String getDisplayHref() {
        return displayHref;
    }

    public ImageAdWeb getImageAd() {
        return imageAd;
    }

    public VideoInfoWeb getVideo() {
        return video;
    }

    public DirectBannerType getBannerType() {
        return bannerType;
    }

    public void setCallouts(List<String> callouts) {
        this.callouts = callouts;
    }

    public void setCallouts(String... callouts) {
        setCallouts(Arrays.asList(callouts));
    }

    public Boolean getIsMobileBannerType() {
        return isMobileBannerType;
    }

    public void setIsMobileBannerType(Boolean state) {
        this.isMobileBannerType = state;
    }

    public void setDisplayHref(String dispHref) {
        this.displayHref = dispHref;
    }

    public void setBannerType(DirectBannerType type) {
        this.bannerType = type;
    }

    public void setImageAd(ImageAdWeb imageAd) {
        this.imageAd = imageAd;
    }

    public void setVideo(VideoInfoWeb video) {
        this.video = video;
    }

    public Boolean getMobileBannerType() {
        return isMobileBannerType;
    }

    public void setMobileBannerType(Boolean mobileBannerType) {
        isMobileBannerType = mobileBannerType;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public void setBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ContactInfoWeb getContactInfo() {
        return contactInfo;
    }

    public void setContactInfo(ContactInfoWeb contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getGeo() {
        return toSortedGeo(geo);
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public BannerPhraseInfoWeb[] getPhrases() {
        return phrases;
    }

    public void setPhrases(BannerPhraseInfoWeb[] phrases) {
        this.phrases = phrases;
    }

    public String[] getMinusKeywords() {
        return minusKeywords;
    }

    public void setMinusKeywords(String[] minusKeywords) {
        this.minusKeywords = minusKeywords;
    }

    public SiteLinkInfoWeb[] getSitelinks() {
        return sitelinks;
    }

    public void setSitelinks(SiteLinkInfoWeb[] sitelinks) {
        this.sitelinks = sitelinks;
    }

    public Long getAdGroupID() {
        return adGroupID;
    }

    public void setAdGroupID(Long adGroupID) {
        this.adGroupID = adGroupID;
    }

    public String getStatusSitelinksModerate() {
        return statusSitelinksModerate;
    }

    public void setStatusSitelinksModerate(String statusSitelinksModerate) {
        this.statusSitelinksModerate = statusSitelinksModerate;
    }

    public String getIsActive() {
        return isActive;
    }

    public void setIsActive(String isActive) {
        this.isActive = isActive;
    }

    public String getTitleExtension() {
        return titleExtension;
    }

    public void setTitleExtension(String titleExtension) {
        this.titleExtension = titleExtension;
    }

    public Double getMaxClickPrice() {
        return maxClickPrice;
    }

    public void setMaxClickPrice(Double maxClickPrice) {
        this.maxClickPrice = maxClickPrice;
    }

    public Boolean isRelevanceMatchEnabled() {
        return isRelevanceMatchEnabled;
    }

    public Boolean getRelevanceMatchEnabled() {
        return isRelevanceMatchEnabled;
    }

    public TurboLandingInfoWeb getTurboLanding() {
        return turboLanding;
    }

    public void setTurboLanding(TurboLandingInfoWeb turboLanding) {
        this.turboLanding = turboLanding;
    }

    public void setRelevanceMatchEnabled(Boolean autoTargetingEnabled) {
        isRelevanceMatchEnabled = autoTargetingEnabled;
    }

    public BannerInfoWeb withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public BannerInfoWeb withCallouts(List<String> callouts) {
        this.callouts = callouts;
        return this;
    }

    public BannerInfoWeb withIsMobileBannerType(Boolean isMobileBannerType) {
        this.isMobileBannerType = isMobileBannerType;
        return this;
    }

    public BannerInfoWeb withDisplayHref(String displayHref) {
        this.displayHref = displayHref;
        return this;
    }

    public BannerInfoWeb withBannerType(DirectBannerType bannerType) {
        this.bannerType = bannerType;
        return this;
    }

    public BannerInfoWeb withImageAd(ImageAdWeb imageAd) {
        this.imageAd = imageAd;
        return this;
    }

    public BannerInfoWeb withVideo(VideoInfoWeb video) {
        this.video = video;
        return this;
    }

    public BannerInfoWeb withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public BannerInfoWeb withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public BannerInfoWeb withTitle(String title) {
        this.title = title;
        return this;
    }

    public BannerInfoWeb withTitleExtension(String titleExtension) {
        this.titleExtension = titleExtension;
        return this;
    }

    public BannerInfoWeb withText(String text) {
        this.text = text;
        return this;
    }

    public BannerInfoWeb withHref(String href) {
        this.href = href;
        return this;
    }

    public BannerInfoWeb withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public BannerInfoWeb withContactInfo(ContactInfoWeb contactInfo) {
        this.contactInfo = contactInfo;
        return this;
    }

    public BannerInfoWeb withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public BannerInfoWeb withPhrases(BannerPhraseInfoWeb[] phrases) {
        this.phrases = phrases;
        return this;
    }

    public BannerInfoWeb withStatusSitelinksModerate(String statusSitelinksModerate) {
        this.statusSitelinksModerate = statusSitelinksModerate;
        return this;
    }

    public BannerInfoWeb withMinusKeywords(String[] minusKeywords) {
        this.minusKeywords = minusKeywords;
        return this;
    }

    public BannerInfoWeb withStatusShow(String statusShow) {
        this.statusShow = statusShow;
        return this;
    }

    public BannerInfoWeb withSitelinks(SiteLinkInfoWeb[] sitelinks) {
        this.sitelinks = sitelinks;
        return this;
    }

    public BannerInfoWeb withAdGroupID(Long adGroupID) {
        this.adGroupID = adGroupID;
        return this;
    }

    public BannerInfoWeb withHierarchicalMultipliersWeb(HierarchicalMultipliersWeb hierarchicalMultipliersWeb) {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
        return this;
    }

    public BannerInfoWeb withAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
        return this;
    }

    public BannerInfoWeb withIsActive(String active) {
        this.isActive = active;
        return this;
    }

    public BannerInfoWeb withMaxClickPrice(Double maxClickPrice) {
        this.maxClickPrice = maxClickPrice;
        return this;
    }

    public BannerInfoWeb withIsRelevanceMatchEnabled(Boolean isAutoTargetingEnabled) {
        this.isRelevanceMatchEnabled = isAutoTargetingEnabled;
        return this;
    }

    public BannerInfoWeb withTurboLanding(TurboLandingInfoWeb turboLanding) {
        this.turboLanding = turboLanding;
        return this;
    }


    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    /**
     * TODO: Костыль
     * всегда храним в сортированном порядке регионы, так как их порядок не детерминирован и это ломает сравнение
     */
    private String toSortedGeo(String regions) {
        return regions == null ? null
                : Stream.of(regions.split(","))
                .sorted()
                .collect(Collectors.joining(","));
    }
}
