package ru.yandex.autotests.direct.web.objects.banners;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.io.Serializable;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class BannerPhraseInfoWeb implements Serializable {
    private String currentOnSearch;
    private String state;


    private String phrase;
    private Integer clicks;
    private Integer shows;
    private Float contextPrice;
    private Long bannerId;
    private Float price;
    private Long phraseID;
    private Long campaignId;
    private Float minPrice;
    private String autoBudgetPriority;
    private Long adGroupID;
    private Boolean active;
    private Long trafficVolumeForecast;

    public Boolean getActive() {
        return active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getPhrase() {
        return phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public Integer getClicks() {
        return clicks;
    }

    public void setClicks(Integer clicks) {
        this.clicks = clicks;
    }

    public Integer getShows() {
        return shows;
    }

    public void setShows(Integer shows) {
        this.shows = shows;
    }

    public Float getContextPrice() {
        return contextPrice;
    }

    public void setContextPrice(Float contextPrice) {
        this.contextPrice = contextPrice;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public void setBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }

    public Float getPrice() {
        return price;
    }

    public void setPrice(Float price) {
        this.price = price;
    }

    public Long getPhraseID() {
        return phraseID;
    }

    public void setPhraseID(Long phraseID) {
        this.phraseID = phraseID;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignID(Long campaignId) {
        this.campaignId = campaignId;
    }

    public Float getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Float minPrice) {
        this.minPrice = minPrice;
    }

    public String getAutoBudgetPriority() {
        return autoBudgetPriority;
    }

    public void setAutoBudgetPriority(String autoBudgetPriority) {
        this.autoBudgetPriority = autoBudgetPriority;
    }

    public Long getAdGroupID() {
        return adGroupID;
    }

    public void setAdGroupID(Long adGroupID) {
        this.adGroupID = adGroupID;
    }

    public String getCurrentOnSearch() {
        return currentOnSearch;
    }

    public void setCurrentOnSearch(String currentOnSearch) {
        this.currentOnSearch = currentOnSearch;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Long getTrafficVolumeForecast() {
        return trafficVolumeForecast;
    }

    public void setTrafficVolumeForecast(Long trafficVolume) {
        this.trafficVolumeForecast = trafficVolume;
    }

    public BannerPhraseInfoWeb withPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    public BannerPhraseInfoWeb withClicks(Integer clicks) {
        this.clicks = clicks;
        return this;
    }

    public BannerPhraseInfoWeb withShows(Integer shows) {
        this.shows = shows;
        return this;
    }

    public BannerPhraseInfoWeb withContextPrice(Float contextPrice) {
        this.contextPrice = contextPrice;
        return this;
    }

    public BannerPhraseInfoWeb withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public BannerPhraseInfoWeb withPrice(Float price) {
        this.price = price;
        return this;
    }

    public BannerPhraseInfoWeb withPhraseID(Long phraseID) {
        this.phraseID = phraseID;
        return this;
    }

    public BannerPhraseInfoWeb withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public BannerPhraseInfoWeb withMinPrice(Float minPrice) {
        this.minPrice = minPrice;
        return this;
    }

    public BannerPhraseInfoWeb withAutoBudgetPriority(String autoBudgetPriority) {
        this.autoBudgetPriority = autoBudgetPriority;
        return this;
    }

    public BannerPhraseInfoWeb withAdGroupID(Long adGroupID) {
        this.adGroupID = adGroupID;
        return this;
    }

    public BannerPhraseInfoWeb withActive(Boolean active) {
        this.active = active;
        return this;
    }

    public BannerPhraseInfoWeb withCurrentOnSearch(String currentOnSearch) {
        this.currentOnSearch = currentOnSearch;
        return this;
    }

    public BannerPhraseInfoWeb withState(String state) {
        this.state = state;
        return this;
    }

    public BannerPhraseInfoWeb withTrafficVolumeForecast(Long volumeForecast) {
        this.trafficVolumeForecast = volumeForecast;
        return this;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}