package ru.yandex.autotests.direct.web.objects.banners;

import java.io.Serializable;
import java.util.List;

import ru.yandex.autotests.direct.cmd.data.commons.banner.HashFlags;
import ru.yandex.autotests.direct.web.data.banners.DirectBannerType;
import ru.yandex.autotests.direct.web.data.banners.MobileBannerAdditionalEnum;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.InterestInfoWeb;
import ru.yandex.autotests.direct.web.objects.imagead.ImageAdWeb;

import static java.util.Objects.isNull;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class MobileAppBannerInfoWeb implements Serializable {
    private List<String> tags;

    private Long bannerId;
    private Long adGroupID;
    private Long campaignID;
    private String body;
    private String[] minusKeywords;
    private String geo;
    private String title;
    private Double maxClickPrice;
    private Boolean isRelevanceMatchEnabled;
    private BannerPhraseInfoWeb[] phrases;
    private List<String> reflectedAttrs;
    private DirectBannerType bannerType;
    private String ageLabel;
    private List<InterestInfoWeb> interests;
    private HashFlags hashFlags;
    private GroupMobileInfoWeb groupMobileInfo;
    private String trackingHref;
    private ImageAdWeb imageAd;
    private String adGroupName;
    private List<MobileBannerAdditionalEnum> bannerAdditionalItems;

    public List<String> getTags() {
        return tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    private HierarchicalMultipliersWeb hierarchicalMultipliersWeb;

    public HierarchicalMultipliersWeb getHierarchicalMultipliersWeb() {
        return hierarchicalMultipliersWeb;
    }

    public void setHierarchicalMultipliersWeb(HierarchicalMultipliersWeb hierarchicalMultipliersWeb) {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List<String> getReflectedAttrs() {
        return reflectedAttrs;
    }

    public void setReflectedAttrs(List<String> reflectedAttrs) {
        this.reflectedAttrs = reflectedAttrs;
    }

    public DirectBannerType getBannerType() {
        return bannerType;
    }

    public void setBannerType(DirectBannerType bannerType) {
        this.bannerType = bannerType;
    }

    public GroupMobileInfoWeb getGroupMobileInfo() {
        return groupMobileInfo;
    }

    public void setGroupMobileInfo(GroupMobileInfoWeb groupMobileInfo) {
        this.groupMobileInfo = groupMobileInfo;
    }

    public HashFlags getHashFlags() {
        return hashFlags;
    }

    public void setHashFlags(HashFlags hashFlags) {
        this.hashFlags = hashFlags;
    }

    public String getTrackingHref() {
        return trackingHref;
    }

    public void setTrackingHref(String trackingHref) {
        this.trackingHref = trackingHref;
    }

    public ImageAdWeb getImageAd() {
        return imageAd;
    }

    public void setImageAd(ImageAdWeb imageAd) {
        this.imageAd = imageAd;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public void setBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }

    public Long getAdGroupID() {
        return adGroupID;
    }

    public void setAdGroupID(Long adGroupID) {
        this.adGroupID = adGroupID;
    }

    public String[] getMinusKeywords() {
        return minusKeywords;
    }

    public void setMinusKeywords(String[] minusKeywords) {
        this.minusKeywords = minusKeywords;
    }

    public BannerPhraseInfoWeb[] getPhrases() {
        return phrases;
    }

    public void setPhrases(BannerPhraseInfoWeb[] phrases) {
        this.phrases = phrases;
    }

    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getCampaignID() {
        return campaignID;
    }

    public void setCampaignID(Long campaignID) {
        this.campaignID = campaignID;
    }

    public String getAgeLabel() {
        return ageLabel;
    }

    public void setAgeLabel(String ageLabel) {
        this.ageLabel = ageLabel;
    }

    public Double getMaxClickPrice() {
        return maxClickPrice;
    }

    public void setMaxClickPrice(Double maxClickPrice) {
        this.maxClickPrice = maxClickPrice;
    }

    public Boolean isRelevanceMatchEnabled() {
        return isRelevanceMatchEnabled;
    }

    public List<InterestInfoWeb> getInterests() {
        return interests;
    }

    public void setInterests(List<InterestInfoWeb> interests) {
        this.interests = interests;
    }

    public void setRelevanceMatchEnabled(Boolean autoTargetingEnabled) {
        isRelevanceMatchEnabled = autoTargetingEnabled;
    }

    public String getAdGroupName() {
        return adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public List<MobileBannerAdditionalEnum> getBannerAdditionalItems() {
        return bannerAdditionalItems;
    }

    public void setBannerAdditionalItems(List<MobileBannerAdditionalEnum> bannerAdditionalItems) {
        this.bannerAdditionalItems = bannerAdditionalItems;
    }

    public MobileAppBannerInfoWeb withTags(final List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MobileAppBannerInfoWeb withBannerId(final Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public MobileAppBannerInfoWeb withAdGroupID(Long adGroupID) {
        this.adGroupID = adGroupID;
        return this;
    }

    public MobileAppBannerInfoWeb withAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
        return this;
    }

    public MobileAppBannerInfoWeb withCampaignID(final Long campaignID) {
        this.campaignID = campaignID;
        return this;
    }

    public MobileAppBannerInfoWeb withBody(final String body) {
        this.body = body;
        return this;
    }

    public MobileAppBannerInfoWeb withMinusKeywords(final String[] minusKeywords) {
        this.minusKeywords = minusKeywords;
        return this;
    }

    public MobileAppBannerInfoWeb withGeo(final String geo) {
        this.geo = geo;
        return this;
    }

    public MobileAppBannerInfoWeb withTitle(final String title) {
        this.title = title;
        return this;
    }

    public MobileAppBannerInfoWeb withPhrases(
            final BannerPhraseInfoWeb[] phrases)
    {
        this.phrases = phrases;
        return this;
    }

    public MobileAppBannerInfoWeb withReflectedAttrs(final List<String> reflectedAttrs) {
        this.reflectedAttrs = reflectedAttrs;
        return this;
    }

    public MobileAppBannerInfoWeb withBannerType(
            final DirectBannerType bannerType)
    {
        this.bannerType = bannerType;
        return this;
    }

    public MobileAppBannerInfoWeb withAgeLabel(final String ageLabel) {
        this.ageLabel = ageLabel;
        return this;
    }

    public MobileAppBannerInfoWeb withHashFlags(
            final HashFlags hashFlags)
    {
        this.hashFlags = hashFlags;
        return this;
    }

    public MobileAppBannerInfoWeb withGroupMobileInfo(
            final GroupMobileInfoWeb groupMobileInfo)
    {
        this.groupMobileInfo = groupMobileInfo;
        return this;
    }

    public MobileAppBannerInfoWeb withTrackingHref(final String trackingHref) {
        this.trackingHref = trackingHref;
        return this;
    }

    public MobileAppBannerInfoWeb withImageAd(final ImageAdWeb imageAd) {
        this.imageAd = imageAd;
        return this;
    }

    public MobileAppBannerInfoWeb withHierarchicalMultipliersWeb(
            final HierarchicalMultipliersWeb hierarchicalMultipliersWeb)
    {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
        return this;
    }

    public MobileAppBannerInfoWeb withMaxClickPrice(Double maxClickPrice) {
        this.maxClickPrice = maxClickPrice;
        return this;
    }

    public MobileAppBannerInfoWeb withIsRelevanceMatchEnabled(Boolean isAutoTargetingEnabled) {
        this.isRelevanceMatchEnabled = isAutoTargetingEnabled;
        return this;
    }

    public MobileAppBannerInfoWeb withInterests(List<InterestInfoWeb> interests) {
        this.interests = interests;
        return this;
    }

    public MobileAppBannerInfoWeb withBannerAdditionalItems(List<MobileBannerAdditionalEnum> bannerAdditionalItems) {
        this.bannerAdditionalItems = bannerAdditionalItems;
        return this;
    }
}