package ru.yandex.autotests.direct.web.objects.banners;

import ru.yandex.autotests.direct.utils.strategy.data.StrategyType;
import ru.yandex.autotests.direct.web.data.banners.*;

public class SearchBannersInfoWeb {

    private String searchText;

    private BannerType bannerType;

    private BannerSearchTypeEnum bannersSearchType;

    private Boolean searchOnlyActive;

    private Boolean groupByCampaigns;

    private Boolean oldNoCurrencyCampaigns;

    private Boolean strictSearch;

    private PlatformOptionEum platformOptionValue;

    private ExtendedBannerSearchOptionEnum relevantPhraseShowsValue;

    private ExtendedBannerSearchOptionEnum retargetingConditionsValue;

    private StrategyType strategy;

    public String getSearchText() {
        return searchText;
    }

    public String getBannerType() {
        return this.bannerType.getValue();
    }

    public String getBannersSearchTypeValue() {
        if (bannerType == null || bannersSearchType == null) {
            return null;
        }
        if (this.bannerType.equals(BannerType.MCB))
            return bannersSearchType.toString() + "_media";
        return bannersSearchType.toString();
    }

    public Boolean getSearchOnlyActive() {
        return searchOnlyActive;
    }

    public Boolean getGroupByCampaigns() {
        return groupByCampaigns;
    }

    public String getRelevantPhraseShowsValue() {
        if (relevantPhraseShowsValue == null) {
            return null;
        }
        return relevantPhraseShowsValue.getValue();
    }

    public String getRetargetingConditionsValue() {
        if (retargetingConditionsValue == null) {
            return null;
        }
        return retargetingConditionsValue.getValue();
    }

    public String getStrategyValue() {
        if (this.strategy == null) {
            return null;
        }
        if (strategy.getSubRadioKey() == null) {
            return strategy.getRadioKey().replaceAll("-", "_");
        }
        return strategy.getRadioKey().replaceAll("-", "_") + "_" + strategy.getSubRadioKey().replaceAll("-", "_");
    }

    public StrategyType getStrategy() {
        return this.strategy;
    }

    public void setStrategy(StrategyType strategy) {
        this.strategy = strategy;
    }

    public String getPlatformOptionValue() {
        if (platformOptionValue == null) {
            return null;
        }
        return platformOptionValue.getValue();
    }

    public Boolean getOldNoCurrencyArchivedCampaigns() {
        return oldNoCurrencyCampaigns;
    }

    public Boolean getStrictSearch() {
        return strictSearch;
    }
}