package ru.yandex.autotests.direct.web.objects.banners.commons;

import java.io.Serializable;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class SiteLinkInfoWeb implements Serializable {
    private String title;
    private String href;
    private TurboLandingInfoWeb turboLanding;

    public SiteLinkInfoWeb() {
    }

    public SiteLinkInfoWeb(String title, String href) {
        this.title = title;
        this.href = href;
    }

    public SiteLinkInfoWeb(String title, String href, TurboLandingInfoWeb turboLandingInfoWeb) {
        this(title, href);
        setTurboLanding(turboLandingInfoWeb);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public TurboLandingInfoWeb getTurboLanding() {
        return turboLanding;
    }

    public void setTurboLanding(TurboLandingInfoWeb turboLanding) {
        this.turboLanding = turboLanding;
    }

    public SiteLinkInfoWeb withTitle(String title) {
        this.title = title;
        return this;
    }

    public SiteLinkInfoWeb withHref(String href) {
        this.href = href;
        return this;
    }

    public SiteLinkInfoWeb withTurboLanding(TurboLandingInfoWeb turboLanding) {
        this.turboLanding = turboLanding;
        return this;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
