package ru.yandex.autotests.direct.web.objects.campaigns;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import ru.yandex.autotests.direct.web.data.AttributionModelEnum;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.CampaignContextStrategyWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.CampaignStrategyWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.EmailNotificationInfoWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.SmsNotificationInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;

public class CampaignInfoWeb {
    private Long campaignId;
    private String Fio;
    private java.util.Date endDate;
    private SmsNotificationInfoWeb smsNotificationWeb;
    private String geo;
    private List<String> disabledIpsList;
    private List<String> disabledDomainsList;
    private String favoriteCampaign;
    private Boolean payEmptyCamp;
    private String bannersPerPage;
    private List<String> deviceTypeTargeting;
    private List<String> networkTargeting;
    private HierarchicalMultipliersWeb hierarchicalMultipliersWeb;
    private Boolean noTitleSubstitute;
    private Boolean extendedGeotargeting;
    private RelevantPhrasesInfo relevantPhrasesWeb;
    private String disabledDomains;
    private String disabledIps;
    private String[] minusKeywords;
    private int[] additionalMetrikaCounters;
    private EmailNotificationInfoWeb emailNotification;
    private SmsNotificationInfoWeb smsNotification;
    private CampaignContextStrategyWeb contextStrategy;
    private String name;
    private Date startDate;
    private CampaignStrategyWeb strategy;
    private String statusMetricaControl;
    private Double sum;
    private String considerRivalsBanners;
    private AttributionModelEnum attributionModel;
    private CampaignGoal campaignGoal;
    private String appName;

    public enum CampaignGoal {
        APP_INSTALLATION("installs"),
        CLICKS("clicks");

        private String value;

        CampaignGoal(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        public static CampaignGoal deserialize(String value) {
            return Arrays.stream(CampaignGoal.values())
                    .filter(val -> val.value.equals(value))
                    .findFirst()
                    .orElseThrow(() -> new DirectWebError("Ошибка десириализации для значения: " + value));
        }
    }

    public Long getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public List<String> getDisabledIpsList() {
        return disabledIpsList;
    }

    public void setDisabledIpsList(List<String> disabledIpsList) {
        this.disabledIpsList = disabledIpsList;
    }

    public List<String> getDisabledDomainsList() {
        return disabledDomainsList;
    }

    public void setDisabledDomainsList(List<String> disabledDomainsList) {
        this.disabledDomainsList = disabledDomainsList;
    }

    public String getFavoriteCampaign() {
        return favoriteCampaign;
    }

    public void setFavoriteCampaign(String favoriteCampaign) {
        this.favoriteCampaign = favoriteCampaign;
    }

    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public SmsNotificationInfoWeb getSmsNotificationWeb() {
        return smsNotificationWeb;
    }

    public void setSmsNotificationWeb(SmsNotificationInfoWeb smsNotificationWeb) {
        this.smsNotificationWeb = smsNotificationWeb;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Boolean getPayEmptyCamp() {
        return payEmptyCamp;
    }

    public void setPayEmptyCamp(Boolean payEmptyCamp) {
        this.payEmptyCamp = payEmptyCamp;
    }

    public String getBannersPerPage() {
        return bannersPerPage;
    }

    public void setBannersPerPage(String bannersPerPage) {
        this.bannersPerPage = bannersPerPage;
    }

    public List<String> getDeviceTypeTargeting() {
        return deviceTypeTargeting;
    }

    public void setDeviceTypeTargeting(List<String> deviceTypeTargeting) {
        this.deviceTypeTargeting = deviceTypeTargeting;
    }

    public List<String> getNetworkTargeting() {
        return networkTargeting;
    }

    public void setNetworkTargeting(List<String> networkTargeting) {
        this.networkTargeting = networkTargeting;
    }

    public HierarchicalMultipliersWeb getHierarchicalMultipliersWeb() {
        return hierarchicalMultipliersWeb;
    }

    public void setHierarchicalMultipliersWeb(HierarchicalMultipliersWeb hierarchicalMultipliersWeb) {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
    }

    public Boolean getNoTitleSubstitute() {
        return noTitleSubstitute;
    }

    public void setNoTitleSubstitute(Boolean noTitleSubstitute) {
        this.noTitleSubstitute = noTitleSubstitute;
    }

    public Boolean getExtendedGeotargeting() {
        return extendedGeotargeting;
    }

    public void setExtendedGeotargeting(Boolean extendedGeotargeting) {
        this.extendedGeotargeting = extendedGeotargeting;
    }

    public RelevantPhrasesInfo getRelevantPhrases() {
        return relevantPhrasesWeb;
    }

    public void setRelevantPhrases(RelevantPhrasesInfo relevantPhrases) {
        this.relevantPhrasesWeb = relevantPhrases;
    }

    public String getDisabledDomains() {
        return this.disabledDomains;
    }

    public void setDisabledDomains(String disabledDomains) {
        this.disabledDomains = disabledDomains;
    }

    public String getDisabledIps() {
        return this.disabledIps;
    }

    public void setDisabledIps(String disabledIps) {
        this.disabledIps = disabledIps;
    }

    public String[] getMinusKeywords() {
        return this.minusKeywords;
    }

    public void setMinusKeywords(String[] minusKeywords) {
        this.minusKeywords = minusKeywords;
    }

    public int[] getAdditionalMetrikaCounters() {
        return this.additionalMetrikaCounters;
    }

    public void setAdditionalMetrikaCounters(int[] additionalMetrikaCounters) {
        this.additionalMetrikaCounters = additionalMetrikaCounters;
    }

    public EmailNotificationInfoWeb getEmailNotification() {
        return this.emailNotification;
    }

    public void setEmailNotification(EmailNotificationInfoWeb emailNotification) {
        this.emailNotification = emailNotification;
    }

    public SmsNotificationInfoWeb getSmsNotification() {
        return this.smsNotification;
    }

    public void setSmsNotification(SmsNotificationInfoWeb smsNotification) {
        this.smsNotification = smsNotification;
    }

    public CampaignContextStrategyWeb getContextStrategy() {
        return this.contextStrategy;
    }

    public void setContextStrategy(CampaignContextStrategyWeb contextStrategy) {
        this.contextStrategy = contextStrategy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public CampaignStrategyWeb getStrategy() {
        return this.strategy;
    }

    public void setStrategy(CampaignStrategyWeb strategy) {
        this.strategy = strategy;
    }

    public String getStatusMetricaControl() {
        return this.statusMetricaControl;
    }

    public void setStatusMetricaControl(String statusMetricaControl) {
        this.statusMetricaControl = statusMetricaControl;
    }

    public String getFio() {
        return Fio;
    }

    public void setFio(String fio) {
        Fio = fio;
    }

    public RelevantPhrasesInfo getRelevantPhrasesWeb() {
        return relevantPhrasesWeb;
    }

    public void setRelevantPhrasesWeb(RelevantPhrasesInfo relevantPhrasesWeb) {
        this.relevantPhrasesWeb = relevantPhrasesWeb;
    }

    public String getConsiderRivalsBanners() {
        return this.considerRivalsBanners;
    }

    public void setConsiderRivalsBanners(String considerRivalsBanners) {
        this.considerRivalsBanners = considerRivalsBanners;
    }

    public Double getSum() {
        return sum;
    }

    public void setSum(Double sum) {
        this.sum = sum;
    }

    public AttributionModelEnum getAttributionModel() {
        return attributionModel;
    }

    public void setAttributionModel(AttributionModelEnum attributionModel) {
        this.attributionModel = attributionModel;
    }

    public CampaignGoal getCampaignGoal() {
        return campaignGoal;
    }

    public void setCampaignGoal(CampaignGoal campaignGoal) {
        this.campaignGoal = campaignGoal;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean containsExtendedData() {
        return getDisabledDomainsList() != null || getDisabledIpsList() != null || getConsiderRivalsBanners() != null
                || getFavoriteCampaign() != null || getPayEmptyCamp() != null || getBannersPerPage() != null ||
                getNoTitleSubstitute() != null;
    }

    public CampaignInfoWeb withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public CampaignInfoWeb withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public CampaignInfoWeb withSmsNotificationWeb(SmsNotificationInfoWeb smsNotificationWeb)
    {
        this.smsNotificationWeb = smsNotificationWeb;
        return this;
    }

    public CampaignInfoWeb withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public CampaignInfoWeb withDisabledIpsList(List<String> disabledIpsList) {
        this.disabledIpsList = disabledIpsList;
        return this;
    }

    public CampaignInfoWeb withDisabledDomainsList(List<String> disabledDomainsList) {
        this.disabledDomainsList = disabledDomainsList;
        return this;
    }

    public CampaignInfoWeb withFavoriteCampaign(String favoriteCampaign) {
        this.favoriteCampaign = favoriteCampaign;
        return this;
    }

    public CampaignInfoWeb withPayEmptyCamp(Boolean payEmptyCamp) {
        this.payEmptyCamp = payEmptyCamp;
        return this;
    }

    public CampaignInfoWeb withBannersPerPage(String bannersPerPage) {
        this.bannersPerPage = bannersPerPage;
        return this;
    }

    public CampaignInfoWeb withDeviceTypeTargeting(List<String> deviceTypeTargeting) {
        this.deviceTypeTargeting = deviceTypeTargeting;
        return this;
    }

    public CampaignInfoWeb withNetworkTargeting(List<String> networkTargeting) {
        this.networkTargeting = networkTargeting;
        return this;
    }

    public CampaignInfoWeb withHierarchicalMultipliersWeb(
            HierarchicalMultipliersWeb hierarchicalMultipliersWeb)
    {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
        return this;
    }

    public CampaignInfoWeb withNoTitleSubstitute(Boolean noTitleSubstitute) {
        this.noTitleSubstitute = noTitleSubstitute;
        return this;
    }

    public CampaignInfoWeb withExtendedGeotargeting(Boolean extendedGeotargeting) {
        this.extendedGeotargeting = extendedGeotargeting;
        return this;
    }

    public CampaignInfoWeb withRelevantPhrasesWeb(
            RelevantPhrasesInfo relevantPhrasesWeb)
    {
        this.relevantPhrasesWeb = relevantPhrasesWeb;
        return this;
    }

    public CampaignInfoWeb withDisabledDomains(String disabledDomains) {
        this.disabledDomains = disabledDomains;
        return this;
    }

    public CampaignInfoWeb withDisabledIps(String disabledIps) {
        this.disabledIps = disabledIps;
        return this;
    }

    public CampaignInfoWeb withMinusKeywords(String[] minusKeywords) {
        this.minusKeywords = minusKeywords;
        return this;
    }

    public CampaignInfoWeb withAdditionalMetrikaCounters(int[] additionalMetrikaCounters) {
        this.additionalMetrikaCounters = additionalMetrikaCounters;
        return this;
    }

    public CampaignInfoWeb withEmailNotification(
            EmailNotificationInfoWeb emailNotification)
    {
        this.emailNotification = emailNotification;
        return this;
    }

    public CampaignInfoWeb withSmsNotification(
            SmsNotificationInfoWeb smsNotification)
    {
        this.smsNotification = smsNotification;
        return this;
    }

    public CampaignInfoWeb withContextStrategy(
            CampaignContextStrategyWeb contextStrategy)
    {
        this.contextStrategy = contextStrategy;
        return this;
    }

    public CampaignInfoWeb withName(String name) {
        this.name = name;
        return this;
    }

    public CampaignInfoWeb withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public CampaignInfoWeb withStrategy(
            CampaignStrategyWeb strategy)
    {
        this.strategy = strategy;
        return this;
    }

    public CampaignInfoWeb withStatusMetricaControl(String statusMetricaControl) {
        this.statusMetricaControl = statusMetricaControl;
        return this;
    }

    public CampaignInfoWeb withConsiderRivalsBanners(String considerRivalsBanners) {
        this.considerRivalsBanners = considerRivalsBanners;
        return this;
    }

    public CampaignInfoWeb withSum(Double sum) {
        this.sum = sum;
        return this;
    }

    public CampaignInfoWeb withAttributionModel(AttributionModelEnum attributionModel) {
        this.attributionModel = attributionModel;
        return this;
    }

    public CampaignInfoWeb withAppName(String appName) {
        this.appName = appName;
        return this;
    }
}
