package ru.yandex.autotests.direct.web.objects.groups;

import java.util.List;

import ru.yandex.autotests.direct.web.data.banners.CpmTargetingType;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.InterestsSocDemTargetingInfoWeb;

public class CpmTargetingInfoWeb {

    private CpmTargetingType targetingType;
    //keywords fields
    private List<BannerPhraseInfoWeb> phrases;
    private List<String> minusPhrases;
    private HierarchicalMultipliersWeb hierarchicalMultipliersWeb;
    //interests fields
    private InterestsSocDemTargetingInfoWeb interestsSocDemTargeting;

    public CpmTargetingType getTargetingType() {
        return targetingType;
    }

    public void setTargetingType(CpmTargetingType targetingType) {
        this.targetingType = targetingType;
    }

    public List<BannerPhraseInfoWeb> getPhrases() {
        return phrases;
    }

    public void setPhrases(List<BannerPhraseInfoWeb> phrases) {
        this.phrases = phrases;
    }

    public List<String> getMinusPhrases() {
        return minusPhrases;
    }

    public void setMinusPhrases(List<String> minusPhrases) {
        this.minusPhrases = minusPhrases;
    }

    public HierarchicalMultipliersWeb getHierarchicalMultipliersWeb() {
        return hierarchicalMultipliersWeb;
    }

    public void setHierarchicalMultipliersWeb(HierarchicalMultipliersWeb hierarchicalMultipliersWeb) {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
    }

    public InterestsSocDemTargetingInfoWeb getInterestsSocDemTargeting() {
        return interestsSocDemTargeting;
    }

    public void setInterestsSocDemTargeting(InterestsSocDemTargetingInfoWeb interestsSocDemTargeting) {
        this.interestsSocDemTargeting = interestsSocDemTargeting;
    }

    public CpmTargetingInfoWeb withTargetingType(CpmTargetingType targetingType) {
        this.targetingType = targetingType;
        return this;
    }

    public CpmTargetingInfoWeb withPhrases(List<BannerPhraseInfoWeb> phrases) {
        this.phrases = phrases;
        return this;
    }

    public CpmTargetingInfoWeb withMinusPhrases(List<String> minusPhrases) {
        this.minusPhrases = minusPhrases;
        return this;
    }

    public CpmTargetingInfoWeb withHierarchicalMultipliersWeb(HierarchicalMultipliersWeb hierarchicalMultipliersWeb) {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
        return this;
    }

    public CpmTargetingInfoWeb withInterestsSocDemTargeting(InterestsSocDemTargetingInfoWeb interestsSocDemTargeting) {
        this.interestsSocDemTargeting = interestsSocDemTargeting;
        return this;
    }
}
