package ru.yandex.autotests.direct.web.objects.groups;

import java.util.List;

import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.McBannerInfoWeb;

public class McGroupInfoWeb {
    private Long campaignId;
    private String adGroupName;
    private Long adGroupId;
    private List<McBannerInfoWeb> banners;
    private BannerPhraseInfoWeb[] phrases;
    private String[] minusKeywords;
    private String geo;
    private List<String> tags;
    private HierarchicalMultipliersWeb hierarchicalMultipliersWeb;
    private Double maxClickPrice;

    public Long getCampaignId() {
        return campaignId;
    }

    public String getAdGroupName() {
        return adGroupName;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public List<McBannerInfoWeb> getBanners() {
        return banners;
    }

    public BannerPhraseInfoWeb[] getPhrases() {
        return phrases;
    }

    public String[] getMinusKeywords() {
        return minusKeywords;
    }

    public String getGeo() {
        return geo;
    }

    public List<String> getTags() {
        return tags;
    }

    public HierarchicalMultipliersWeb getHierarchicalMultipliersWeb() {
        return hierarchicalMultipliersWeb;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public void setBanners(List<McBannerInfoWeb> banners) {
        this.banners = banners;
    }

    public void setPhrases(BannerPhraseInfoWeb[] phrases) {
        this.phrases = phrases;
    }

    public void setMinusKeywords(String[] minusKeywords) {
        this.minusKeywords = minusKeywords;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setHierarchicalMultipliersWeb(
            HierarchicalMultipliersWeb hierarchicalMultipliersWeb)
    {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
    }

    public Double getMaxClickPrice() {
        return maxClickPrice;
    }

    public void setMaxClickPrice(Double maxClickPrice) {
        this.maxClickPrice = maxClickPrice;
    }

    public McGroupInfoWeb withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public McGroupInfoWeb withAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
        return this;
    }

    public McGroupInfoWeb withAdGroupID(Long adGroupID) {
        this.adGroupId = adGroupID;
        return this;
    }

    public McGroupInfoWeb withBanners(List<McBannerInfoWeb> banners) {
        this.banners = banners;
        return this;
    }

    public McGroupInfoWeb withPhrases(BannerPhraseInfoWeb[] phrases) {
        this.phrases = phrases;
        return this;
    }

    public McGroupInfoWeb withMinusKeywords(String[] minusKeywords) {
        this.minusKeywords = minusKeywords;
        return this;
    }

    public McGroupInfoWeb withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public McGroupInfoWeb withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public McGroupInfoWeb withHierarchicalMultipliersWeb(HierarchicalMultipliersWeb hierarchicalMultipliersWeb) {
        this.hierarchicalMultipliersWeb = hierarchicalMultipliersWeb;
        return this;
    }

    public McGroupInfoWeb withMaxClickPrice(Double maxClickPrice) {
        this.maxClickPrice = maxClickPrice;
        return this;
    }
}
