package ru.yandex.autotests.direct.web.objects.retargeting;

import java.util.NoSuchElementException;
import java.util.stream.Stream;

public enum RetargetingConditionGoalType {
    METRIKA_GOAL("metrika_goal"),
    METRIKA_SEGMENT("metrika_segment"),
    AUDIENCE_SEGMENT("audience_segment");

    private String value;

    private RetargetingConditionGoalType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static RetargetingConditionGoalType getEnumByValue(String value) {
        return Stream.of(values())
                .filter(t -> t.getValue().equals(value))
                .findFirst()
                .orElseThrow(NoSuchElementException::new);
    }
}
