package ru.yandex.autotests.direct.web.objects.statistic;

import java.io.Serializable;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.autotests.direct.web.data.MinusPhraseTargetType;

public class StatisticMinusPhraseInfoWeb implements Serializable {
    private String text;
    private MinusPhraseTargetType target;

    public StatisticMinusPhraseInfoWeb(String text, MinusPhraseTargetType target) {
        this.text = text;
        this.target = target;
    }

    public StatisticMinusPhraseInfoWeb() {
    }

    public String getText() {
        return text;
    }

    public String getTarget() {
        return target.getTargetType();
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTarget(MinusPhraseTargetType target) {
        this.target = target;
    }

    public StatisticMinusPhraseInfoWeb withText(final String text) {
        this.text = text;
        return this;
    }

    public StatisticMinusPhraseInfoWeb withTarget(final MinusPhraseTargetType target) {
        this.target = target;
        return this;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
