package ru.yandex.autotests.direct.web.objects.strategies.cpm;

import java.util.Date;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.autotests.direct.web.data.strategy.cpm.CpmManualShowModeEnum;
import ru.yandex.autotests.direct.web.data.strategy.cpm.CpmStrategiesEnum;
import ru.yandex.autotests.direct.web.data.strategy.cpm.CpmStrategySpendMode;
import ru.yandex.autotests.direct.web.objects.strategies.AbstractStrategyInfoWeb;

public class CpmStrategyInfoWeb extends AbstractStrategyInfoWeb {

    private Boolean isDayBudgetEnabled;
    private Double dayBudget;
    private CpmManualShowModeEnum showMode;

    private CpmStrategiesEnum strategy;
    private CpmStrategySpendMode spendMode;
    private Date dateFrom;
    private Date dateTo;
    private Double budget;
    private Boolean autoProlongation;
    private Double middleCost;

    public CpmStrategySpendMode getSpendMode() {
        return spendMode;
    }

    public void setSpendMode(CpmStrategySpendMode spendMode) {
        this.spendMode = spendMode;
    }

    public Date getDateFrom() {
        return dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public Double getBudget() {
        return budget;
    }

    public void setBudget(Double budget) {
        this.budget = budget;
    }

    public Boolean getAutoProlongation() {
        return autoProlongation;
    }

    public void setAutoProlongation(Boolean autoProlongation) {
        this.autoProlongation = autoProlongation;
    }

    public Double getMiddleCost() {
        return middleCost;
    }

    public void setMiddleCost(Double middleCost) {
        this.middleCost = middleCost;
    }

    public CpmStrategiesEnum getStrategy() {
        return strategy;
    }

    public void setStrategy(CpmStrategiesEnum strategy) {
        this.strategy = strategy;
    }

    public Boolean getDayBudgetEnabled() {
        return isDayBudgetEnabled;
    }

    public void setDayBudgetEnabled(Boolean dayBudgetEnabled) {
        isDayBudgetEnabled = dayBudgetEnabled;
    }

    public Double getDayBudget() {
        return dayBudget;
    }

    public void setDayBudget(Double dayBudget) {
        this.dayBudget = dayBudget;
    }

    public CpmManualShowModeEnum getShowMode() {
        return showMode;
    }

    public void setShowMode(CpmManualShowModeEnum showMode) {
        this.showMode = showMode;
    }

    public CpmStrategyInfoWeb withSpendMode(
            final CpmStrategySpendMode spendMode)
    {
        this.spendMode = spendMode;
        return this;
    }

    public CpmStrategyInfoWeb withDateFrom(final Date dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public CpmStrategyInfoWeb withDateTo(final Date dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public CpmStrategyInfoWeb withBudget(final Double budget) {
        this.budget = budget;
        return this;
    }

    public CpmStrategyInfoWeb withAutoProlongation(final Boolean autoProlongation) {
        this.autoProlongation = autoProlongation;
        return this;
    }

    public CpmStrategyInfoWeb withMiddleCost(final Double middleCost) {
        this.middleCost = middleCost;
        return this;
    }

    public CpmStrategyInfoWeb withStrategy(final CpmStrategiesEnum strategy) {
        this.strategy = strategy;
        return this;
    }

    public CpmStrategyInfoWeb withIsDayBudgetEnabled(final Boolean isDayBudgetEnabled) {
        this.isDayBudgetEnabled = isDayBudgetEnabled;
        return this;
    }

    public CpmStrategyInfoWeb withDayBudget(final Double dayBudget) {
        this.dayBudget = dayBudget;
        return this;
    }

    public CpmStrategyInfoWeb withShowMode(final CpmManualShowModeEnum showMode) {
        this.showMode = showMode;
        return this;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
