package ru.yandex.autotests.direct.web.objects.transfer;

import java.util.ArrayList;
import java.util.List;

/**
 * User: buhter
 * Date: 07.05.13
 * Time: 12:06
 * Бин для заполнения и проверки форм выставления счетов
 */
public class PaymentMoney {
    public final static String REQUEST_ID_PARAMETER_NAME = "request_id";

    private final List<PayCampElement> payCampElementList;

    public PaymentMoney(){
        this.payCampElementList = new ArrayList<>();
    }

    public List<PayCampElement> getPayCampElementList() {
        return payCampElementList;
    }

    public void addCampElement(Long campaignId, String sum) {
        PayCampElement payCampElement = new PayCampElement();
        payCampElement.setCampaignId(campaignId);
        payCampElement.setSum(sum.replace(" ", ""));
        payCampElementList.add(payCampElement);
    }

    public float getTotalPaymentValue() {
        float totalTransferValue = 0f;
        for (PayCampElement payCampElement: payCampElementList) {
            if(payCampElement.getSum() != null){
                totalTransferValue += Float.valueOf(payCampElement.getSum().replace(" ", ""));
            }
        }
        return totalTransferValue;
    }
}