package ru.yandex.autotests.direct.web.objects.transfer;

import org.apache.commons.collections.ListUtils;
import ru.yandex.autotests.direct.utils.money.Money;

import java.util.ArrayList;
import java.util.List;

/**
 * User: buhter
 * Date: 09.04.13
 * Time: 12:30
 * Бин для заполнения и проверки формы переноса средств TransferForm
 */
public class TransferMoney {
    private final List<PayCampElement> fromCampaigns;
    private final List<PayCampElement> toCampaigns;

    public List<PayCampElement> addToCampaign(Long campaignId, String sum) {
        PayCampElement payCampElement = new PayCampElement();
        payCampElement.setCampaignId(campaignId);
        payCampElement.setSum(sum);
        toCampaigns.add(payCampElement);
        return toCampaigns;
    }

    public List<PayCampElement> addFromCampaign(Long campaignId, String sum) {
        PayCampElement payCampElement = new PayCampElement();
        payCampElement.setCampaignId(campaignId);
        payCampElement.setSum(sum);
        fromCampaigns.add(payCampElement);
        return fromCampaigns;
    }

    public List<PayCampElement> addToCampaigns(Long[] campaignIds, String sum) {
        for(Long campaignId: campaignIds){
            PayCampElement payCampElement = new PayCampElement();
            payCampElement.setCampaignId(campaignId);
            payCampElement.setSum(sum);
            toCampaigns.add(payCampElement);
        }
        return toCampaigns;
    }

    public List<PayCampElement> addFromCampaigns(Long[] campaignIds, String sum) {
        for(Long campaignId: campaignIds){
            PayCampElement payCampElement = new PayCampElement();
            payCampElement.setCampaignId(campaignId);
            payCampElement.setSum(sum);
            fromCampaigns.add(payCampElement);
        }
        return fromCampaigns;
    }

    public void addFromCampaign(Long campaignId) {
        addFromCampaign(campaignId, null);
    }

    public void addToCampaign(Long campaignId) {
        addToCampaign(campaignId, null);
    }

    public void addFromCampaigns(Long[] campaignIds) {
        addFromCampaigns(campaignIds, null);
    }

    public void addToCampaigns(Long[] campaignIds) {
        addToCampaigns(campaignIds, null);
    }

    public TransferMoney() {
        this.fromCampaigns = new ArrayList<>();
        this.toCampaigns = new ArrayList<>();
    }

    public List<PayCampElement> getFromCampaigns() {
        return fromCampaigns;
    }

    public List<PayCampElement> getToCampaigns() {
        return toCampaigns;
    }

    public Money getTotalTransferValue() {
        Money totalTransferValue = Money.valueOf(0f);
        for (PayCampElement payCampElement: (List<PayCampElement>)ListUtils.sum(fromCampaigns, toCampaigns)) {
            if(payCampElement.getSum() != null){
                totalTransferValue = totalTransferValue.add(Float.valueOf(payCampElement.getSum()));
            }
        }
       return totalTransferValue;
    }

    public int getToCampaignsAmount() {
        return toCampaigns.size();
    }

    public int getFromCampaignsAmount() {
        return fromCampaigns.size();
    }

    public List<PayCampElement> getAllPayCampElements(){
        return (List<PayCampElement>)ListUtils.sum(fromCampaigns, toCampaigns);
    }


}
