package ru.yandex.autotests.direct.web.pages;

import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

/**
 * Created by aleran on 09.09.2015.
 */
@Name("Попап выбора типа компании")
@FindBy(css = ".b-choose-campaign-type__popup")
public class CampaignChooseBlock extends HtmlElement {

    @Name("Ссылка Создать текстовую кампанию")
    @FindBy(xpath = ".//div[contains(@class, 'campaign-types-list__text')]")
    private Link addTextCampaignLink;

    @Name("Ссылка Создать мобильную кампанию")
    @FindBy(xpath = ".//div[contains(@class, 'campaign-types-list__mobile-content')]")
    private Link addMobileCampaignLink;

    @Name("Ссылка Создать ДМО кампанию")
    @FindBy(xpath = ".//div[contains(@class, 'campaign-types-list__performance')]")
    private Link addPerformanceCampaignLink;

    @Name("Ссылка Создать МС кампанию")
    @FindBy(xpath = ".//div[contains(@class, 'campaign-types-list__mcbanner')]")
    private Link addMcCampaignLink;

    @Name("Ссылка Создать CPM кампанию")
    @FindBy(xpath = ".//div[contains(@class, 'campaign-types-list__cpm-banner')]")
    private Link addCpmCampaignLink;

    public void clickOnAddTextCampaignLink() {
        addTextCampaignLink.click();
    }

    public void clickOnAddMobileCampaignLink() {
        addMobileCampaignLink.click();
    }

    public void clickOnAddPerformanceCampaignLink() {
        addPerformanceCampaignLink.click();
    }

    public void clickOnAddMcCampaignLink() {addMcCampaignLink.click();}

    public void clickOnAddCpmCampaignLink() {
        addCpmCampaignLink.click();
    }
}
