package ru.yandex.autotests.direct.web.pages;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.util.helpers.URLParameterHelper;
import ru.yandex.autotests.passport.api.tools.captcha.CaptchaActions;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@FindBy(css = ".b-captcha-form")
public class CaptchaFormBlock extends ExtendedHtmlElement {

    @Name("Текст капчи")
    @FindBy(css = ".b-captcha-form__captcha")
    private WebElement captchaText;

    @Name("Инпут капчи")
    @FindBy(xpath = ".//input[@name='captcha_code']")
    private TextInput captchaInput;

    @Name("Текст ошибки")
    @FindBy(css = ".b-captcha-form__invalid")
    private WebElement errorText;

    @Name("Кнопка 'продолжить'")
    @FindBy(css = "button")
    private Button continueButton;

    public void fillCaptcha() {
        fillCaptcha(getCaptchaAnswer());
    }

    public void fillCaptcha(String answer) {
        fillTextInput(captchaInput, answer);
    }

    public String getCaptchaAnswer() {
        String key = URLParameterHelper.getUrlParameterByName(captchaText.getAttribute("src"), "key");
        return CaptchaActions.getCaptchaAnswerByKey(key);
    }

    public WebElement getErrorText() {
        return errorText;
    }

    public boolean isCaptchaDisplayed() {
        return WebElementMatchers.isDisplayed().matches(this);
    }

    public void fillIfDisplayed() {
        if (isCaptchaDisplayed()) {
            fillCaptcha();
            clickContinue();
        }
    }

    public void clickContinue() {
        continueButton.click();
    }
}
