package ru.yandex.autotests.direct.web.pages;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.annotations.Timeout;

/*
* todo javadoc
*/
public class DirectCommonPage extends BasePageObject {

    @Name("Информация для разработчиков")
    @FindBy(css = ".b-dev-info")
    @Timeout(0)
    private WebElement devInfo;

    @Name("Шапка")
    @FindBy(css = ".header2")
    @Timeout(0)
    private WebElement header;

    @Name("Подвал")
    @FindBy(css = ".footer")
    @Timeout(0)
    private WebElement footer;

    @Name("Видимый попап")
    @FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible') and not(contains(@class, 'b-infoblock'))]"
            + "/div[contains(@class, 'popup__content')]")
    private WebElement visiblePopup;

    @Name("Видимый попап в DNA")
    @FindBy(css = "div.modal-decorator__content")
    private WebElement visiblePopupDna;

    @Name("Верхний флоатер, появляющийся на страницах")
    @FindBy(xpath = "(.//div[@class='b-floater__content'])[2]")
    @Timeout(0)
    private WebElement floaterToTop;

    @Name("Нижний флоатер, появляющийся на страницах")
    @FindBy(xpath = ".//div[contains(@class,'b-floater__content')]")
    @Timeout(0)
    private WebElement floaterToBottom;

    @Name("Информационная плашка вверху страницы")
    @FindBy(xpath = "(.//div[contains(@class, 'b-min-price-shutdown-warning_js_inited')])")
    private WebElement shutdownWarning;

    @Name("Блок ошибок валидации")
    @FindBy(css = "div.b-validation-errors__wrap")
    private WebElement validationErrors;

    @Name("Общая ошибка для страницы")
    @FindBy(css = "div.p-common-error__error")
    private WebElement commonError;

    @Name("Флоатер с названием группы на странице редактирования группы")
    @FindBy(xpath = ".//div[contains(@class, 'b-floater__bg') or contains(@class, 'b-floater__content')]")
    private List<WebElement> groupFloater;

    @Name("Панель переключения в новый интерфейс")
    @FindBy(css = "div.b-switch-to-dna-panel")
    private WebElement switchToDnaPanel;

    @Name("Всплывающий попап с подсказками")
    @FindBy(css = "div.b-feature-marker__popup")
    private WebElement newFeatureInformPopup;

    @Name("Плашка об устаревшем браузере")
    @FindBy(css = "div.b-page__old-browsers")
    private WebElement oldBrowserPanel;

    @Name("Глобальная плашка")
    @FindBy(css = "div.b-global-warning_type_non-working-week")
    private WebElement globalWarning;

    @Name("Инфоблок")
    @FindBy(xpath = ".//div[contains(@class, 'b-infoblock__mini-popup-content')]/parent::div")
    private WebElement infoblock;

    @Name("Сайдбар нового интерфейса")
    @FindBy(xpath = ".//div[@class='b-page__sidebar']")
    private WebElement dnaSidebar;

    @Name("База и порт беты в шапке")
    @FindBy(xpath = "(.//span[contains(@class, 'header2__config')])[1]")
    private WebElement betaPort;

    @Name("Шапка нового интерфейса")
    @FindBy(xpath = ".//div[contains(@class, 'b-header-dna')]")
    private WebElement dnaHeader;

    @Name("Подсказка из сайдбара нового интерфейса")
    @FindBy(xpath = ".//div[contains(@class, 'sidebar-menu-item-tooltip') and contains(@class, 'popup2_visible_yes')]")
    private WebElement dnaSidebarTooltip;

    @Name("Кнопка закрытия предложения воспользоваться новым интерфейсом")
    @FindBy(css = "span.b-switch-to-dna-panel__close-icon")
    private WebElement dnaInventationClose;

    public WebElement getDevInfo() {
        return devInfo;
    }

    public WebElement getHeader() {
        return header;
    }

    public WebElement getFooter() {
        return footer;
    }

    public WebElement getFloaterToTop() {
        return floaterToTop;
    }

    public WebElement getFloaterToBottom() {
        return floaterToBottom;
    }

    public WebElement getVisiblePopup() {
        return visiblePopup;
    }

    public WebElement getVisiblePopupDna() {
        return visiblePopupDna;
    }

    public WebElement getShutdownWarning() {
        return shutdownWarning;
    }

    public WebElement getValidationErrors() {
        return validationErrors;
    }

    public String getCommonError() {
        return commonError.getText();
    }

    public List<WebElement> getGroupFloater() {
        return groupFloater;
    }

    public WebElement getSwitchToDnaPanel() {
        return switchToDnaPanel;
    }

    public WebElement getNewFeatureInformPopup() {
        return newFeatureInformPopup;
    }

    public WebElement getOldBrowserPanel() {
        return oldBrowserPanel;
    }

    public WebElement getGloabalWarning() {
        return globalWarning;
    }

    public WebElement getInfoblock() {
        return infoblock;
    }

    public WebElement getDnaSidebar() {
        return dnaSidebar;
    }

    public WebElement getBetaPort() {
        return betaPort;
    }

    public WebElement getDnaHeader() {
        return dnaHeader;
    }

    public WebElement getDnaSidebarTooltip() {
        return dnaSidebarTooltip;
    }

    public WebElement getDnaInventationClose() {
        return dnaInventationClose;
    }
}
