package ru.yandex.autotests.direct.web.pages;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.textresources.Strings;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

/**
 * User: buhter
 * Date: 27.08.12
 * Time: 20:31
 */
@Name("Шапка Директа")
@FindBy(xpath = "//div[contains(@class, 'header2_type_direct')]")
public class MenuHeaderBlock extends HtmlElement {
    @Name("Ссылка Мои кампании")
    @FindBy(xpath = ".//a[contains(text(), '" + Strings.LINK_TEXT_MY_CAMPAIGNS + "')]")
    private Link myCampaignsLink;

    @Name("Ссылка Дать объявление")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=edit')] | .//button[contains(@class, 'p-novocaine-morda__new-camp')] " +
            "| .//a[contains(@href, 'cmd=stepZero')] ")
    private Link addBannerLink;

    @Name("Открыть попап создания компании")
    @FindBy(css = ".b-choose-campaign-type__switcher-link")
    private WebElement clickOpenCampaignCreatePopup;

    @Name("Ссылка Поиск")
    @FindBy(xpath = ".//a[contains(text(), '" + Strings.LINK_TEXT_SEARCH + "')]")
    private Link searchLink;

    public void clickOnAddBannerLink() {
        addBannerLink.click();
    }

    public void clickOpenCampaignCreatePopup() {
        clickOpenCampaignCreatePopup.click();
    }

    public void clickOnMyCampaignsLink() {
        myCampaignsLink.click();
    }

    public void clickOnSearchLink() {
        searchLink.click();
    }
}
